library(Racmacs)
library(tibble)
library(ggpubr)
library(ggplot2)
setwd("~/Rdata/Guy/AD.D.S")

EC50 <- read.csv("EC50.csv", header = TRUE)
EC50 <-column_to_rownames(EC50 , var = "X")
map <- acmap(titer_table = EC50)
map <- optimizeMap(
  map                     = map,
  number_of_dimensions    = 2,
  number_of_optimizations = 5000,
  minimum_column_basis    = "none")

map<-keepBestOptimization(map)

mapb<-bootstrapMap(
  map,
  "bayesian",
  bootstrap_repeats = 1000,
  bootstrap_ags = TRUE,
  bootstrap_sr = TRUE,
  reoptimize = TRUE,
  optimizations_per_repeat = 100,
  ag_noise_sd = 0.7,
  titer_noise_sd = 0.7)

#Coloring 

Phyl1 <- c("A/Switzerland/9715293/2013",
           "A/Hong_Kong/4801/2014",
           "A/Texas/50/2012",
           "A/Victoria/361/2011(Ivr-165)",
           "A/Newcastle/67/2016",
           "A/Estonia/91621/2015",
           "A/Utah/11/2011",
           "A/Gambia/G0071436/2012",
           "A/Hanoi/Eli15597/2015",
           "A/Heilongjiang-Xiangyang/1134/2011",
           "A/Perth/16/2009nib-64",
           "A/Tasmania/1018/2015")
Phyl2 <- c("A/Alaska/251/2015",
           "A/Singapore/Infimh-16-0019/2016",
           "A/Kansas/ 14/2017",
           "A/Wisconsin/16/2015",
           "A/Hong_Kong/3089/2017",
           "A/Nagano/2153/2017",
           "A/Sweden/3/2017",
           "A/Moramanga/1907/2017")
Phyl3 <- c("A/Helsinki/823/2013",	
           "A/Helsinki/941/2013")
Phyl4 <- c("A/Ohio/13/2017",
           "A/Ohio/62/2012",
           "A/Ontario/Rv3236/2016",
           "A/Indiana/08/2011",
           "A/Minnesota/11/2010")

srPhyl1 <- c("A/Switzerland/9715293/2013",
             "A/Hong_Kong/4801/2014",
             "A/Texas/50/2012",
             "A.Stockholm.32.2014",
             "A.Switzerland.9715293.2013",
             "A.Hong_Kong.4801.2014",
             "A.Paris.2379.2014",
             "A.Texas.50.2012",
             "A.Stockholm.14.2012",
             "A.Tehran.996.2012",
             "A.Victoria.361.2011.Ivr.165.",
             "A.Newcastle.67.2016",
             "A.Estonia.91621.2015",
             "A.Ankara.2396.2015.88.",
             "A.Stockholm.15.2014",
             "A.Dakar.14.2014",
             "A.Portoalegre.Lacenrs.2376.2014",
             "A.Utah.11.2011",
             "A.Hokkaido.10h079.2011",
             "A.Gambia.G0071436.2012",
             "A.Hanoi.Eli15597.2015",
             "A.Heilongjiang.Xiangyang.1134.2011",
             "A.West_Virginia.17.2012",
             "A.Perth.16.2009nib.64",
             "A.Tasmania.1018.2015",
             "A.Xinjiang.Tianshan.1411.2012")
srPhyl2 <- c("A.New_Caledonia.23.2016",
             "A.Alaska.251.2015",
             "A.Hatay.4990.2016.Tr.08.",
             "A.Tennessee.18.2017",
             "A.Singapore.Infimh.16.0019.2016",
             "A.Brisbane.273.2016",
             "A.Poland.19b.2017",
             "A.Wisconsin.16.2015",
             "A.Indiana.18.2017",
             "A.Hong_Kong.3089.2017",
             "A.Nagano.2153.2017",
             "A.Sweden.3.2017",
             "A.Catalonia.9503s.2017",
             "A.Moramanga.1907.2017")
srPhyl3 <- c("A.Helsinki.823.2013",	
           "A.Helsinki.941.2013")
srPhyl4 <- c("A.Ohio.13.2017",
           "A.Ohio.62.2012",
           "A.Ontario.Rv3236.2016",
           "A.Indiana.08.2011",
           "A.Minnesota.11.2010")

#$srPhystrange <- c("A.Xinjiang.Tianshan.1411.2012")
#Kan17 <-c("A/Kansas/ 14/2017")
#Ala15 <-c("A/Alaska/251/2015")
#Wis15 <-c("A/Wisconsin/16/2015")


Phyl1_ags <- agNames(map) %in% Phyl1 
Phyl2_ags <- agNames(map) %in% Phyl2 
Phyl3_ags <- agNames(map) %in% Phyl3 
Phyl4_ags <- agNames(map) %in% Phyl4 

Phyl1_sr <- srNames(map) %in% srPhyl1 
Phyl2_sr <- srNames(map) %in% srPhyl2 
Phyl3_sr <- srNames(map) %in% srPhyl3 
Phyl4_sr <- srNames(map) %in% srPhyl4

#Phylstrange_sr <- srNames(map) %in% srPhystrange
#Kan17ag <- agNames(map) %in% Kan17
#Ala15ag <- agNames(map) %in% Ala15
#Wis15ag <- agNames(map) %in% Wis15


agFill(map)[Phyl1_ags] <- "coral"
agFill(map)[Phyl2_ags] <- "darkseagreen1"
agFill(map)[Phyl3_ags] <- "darkslategray1"
agFill(map)[Phyl4_ags] <- "blueviolet"

#agFill(map)[Kan17ag] <- "deepskyblue2"
#agFill(map)[Ala15ag] <- "deepskyblue3"
#agFill(map)[Wis15ag] <- "deepskyblue4"


srFill(map)[Phyl1_sr] <- "coral1"
srFill(map)[Phyl2_sr] <- "darkseagreen2"
srFill(map)[Phyl3_sr] <- "darkslategray2"
srFill(map)[Phyl4_sr] <- "darkviolet"

#srFill(map)[Phylstrange_sr] <- "blue"



# coloring mapb

agFill(mapb)[Phyl1_ags] <- "coral"
agFill(mapb)[Phyl2_ags] <- "darkseagreen1"
agFill(mapb)[Phyl3_ags] <- "darkslategray1"
agFill(mapb)[Phyl4_ags] <- "blueviolet"

#agFill(map)[Kan17ag] <- "deepskyblue2"
#agFill(map)[Ala15ag] <- "deepskyblue3"
#agFill(map)[Wis15ag] <- "deepskyblue4"


srFill(mapb)[Phyl1_sr] <- "coral1"
srFill(mapb)[Phyl2_sr] <- "darkseagreen2"
srFill(mapb)[Phyl3_sr] <- "darkslategray2"
srFill(mapb)[Phyl4_sr] <- "darkviolet"

ggplot(mapb)


#mapbb

mapbb<-bootstrapBlobs(mapb ,
                      conf.level = 0.68,
                      smoothing = 6,
                      gridspacing = 0.25,
                      antigens = TRUE,
                      sera = TRUE,
                      method = "ks")


# coloring mapbb

agFill(mapbb)[Phyl1_ags] <- "coral"
agFill(mapbb)[Phyl2_ags] <- "darkseagreen1"
agFill(mapbb)[Phyl3_ags] <- "darkslategray1"
agFill(mapbb)[Phyl4_ags] <- "blueviolet"

#agFill(map)[Kan17ag] <- "deepskyblue2"
#agFill(map)[Ala15ag] <- "deepskyblue3"
#agFill(map)[Wis15ag] <- "deepskyblue4"


srFill(mapbb)[Phyl1_sr] <- "coral1"
srFill(mapbb)[Phyl2_sr] <- "darkseagreen2"
srFill(mapbb)[Phyl3_sr] <- "darkslategray2"
srFill(mapbb)[Phyl4_sr] <- "darkviolet"


ggplot(mapbb)

#procluster

mapbbbp <- procrustesMap(mapb,mapbb)


agFill(mapbbbp)[Phyl1_ags] <- "coral"
agFill(mapbbbp)[Phyl2_ags] <- "darkseagreen1"
agFill(mapbbbp)[Phyl3_ags] <- "darkslategray1"
agFill(mapbbbp)[Phyl4_ags] <- "blueviolet"

#agFill(map)[Kan17ag] <- "deepskyblue2"
#agFill(map)[Ala15ag] <- "deepskyblue3"
#agFill(map)[Wis15ag] <- "deepskyblue4"


srFill(mapbbbp)[Phyl1_sr] <- "coral1"
srFill(mapbbbp)[Phyl2_sr] <- "darkseagreen2"
srFill(mapbbbp)[Phyl3_sr] <- "darkslategray2"
srFill(mapbbbp)[Phyl4_sr] <- "darkviolet"


ggplot(mapbbbp)

#test data
#view(map)
#path_to_titer_file <- system.file("extdata/h3map2004_hitable.csv", package = "Racmacs")
#titer_table        <- read.titerTable(path_to_titer_file)
#map2 <- acmap(titer_table = titer_table)

#plot with stress 

plot(map,plot_stress = TRUE)
plot(map50000,plot_stress=TRUE)

# Testing the number of optimizations
map100 <- optimizeMap(
  map                     = map,
  number_of_dimensions    = 2,
  number_of_optimizations = 100,
  minimum_column_basis    = "none")

plot(map, plot_stress = 500)
plot(map100,plot_stress = TRUE)

map100 <- procrustesMap(map,map100)

map10 <- optimizeMap(
  map                     = map,
  number_of_dimensions    = 2,
  number_of_optimizations = 100,
  minimum_column_basis    = "none")

map10 <- procrustesMap(map,map10)
plot(map10,plot_stress= TRUE)

map2 <- optimizeMap(
  map                     = map,
  number_of_dimensions    = 2,
  number_of_optimizations = 2,
  minimum_column_basis    = "none")

map2 <- procrustesMap(map,map2)
plot(map2,plot_stress= TRUE)

# keepbest optimization
mapbest<-keepBestOptimization(map)
plot(mapbest,plot_stress= TRUE)

#Calculating stress per optimization

agStress(map, antigens = TRUE, optimization_number = 5)
srStress(map, sera = TRUE, optimization_number = 500)

srStressPerTiter(map, sera = TRUE, optimization_number = 500)

#stress map

mapS1 <- mapStress(map, optimization_number = 1)
mapS5 <- mapStress(map, optimization_number = 5)
mapS25 <- mapStress(map, optimization_number = 25)
mapS125 <- mapStress(map, optimization_number = 125)
mapS500 <- mapStress(map, optimization_number = 500)
mapS5000 <- mapStress(map, optimization_number = 5000)

plot(map5000,plot_stress= TRUE)

stresstable1<-stressTable(map, optimization_number = 5)
stresstable500<-stressTable(map, optimization_number = 500)
write.csv(stresstable1,"stresstable1.csv")
write.csv(stresstable500,"stresstable500")



